# 등차수열

연속된 두 항의 차이가 항상 같을 때 그 수열을 `등차수열`이라고 한다. 간단히 말해, 이전 항에 상수를 더하여 다음 항을 계산하여 등차수열을 만들 수 있다.

예를 들어, `2, 4, 6, 8, 10`은 연속된 두 항의 차이(공차)가 모두 같으므로 등차수열이다 (4 - 2 = 6 - 4 = 8 - 6 = 10 - 8 = 2).

<p align="center">
    <img width="60%" src="https://user-images.githubusercontent.com/75872316/122635132-ce38d100-d0ff-11eb-8fdf-2e14a9f640cc.png">
</p>

**등차수열에 관한 사실들:**

1. 초항: 등차수열에서, 수열의 첫 항은 초항이라고 불린다.
2. 공차: 연속된 두 항의 차이를 공차라고 한다.
3. 등차수열의 경향성은 공차 `d`에 따라 결정된다. 만약 공차가 양수라면, 모든 항은 양의 무한대를 향해 증가한다. 하지만 만약 공차가 음수라면, 모든 항은 음의 무한대를 향해 감소한다.

**등차수열의 n번째 항 공식:**

<img src="https://render.githubusercontent.com/render/math?math=a">가 초항, <img src="https://render.githubusercontent.com/render/math?math=d">가 공차일 때, <img src="https://render.githubusercontent.com/render/math?math=n">번째 항은:

<p align="center">
    <img width="60%" src="https://user-images.githubusercontent.com/75872316/122635193-25d73c80-d100-11eb-9015-344d36633704.png">
</p>

**등차급수(등차수열의 첫 n항의 합) 공식:**

<p align="center">
    <img width="60%" src="https://user-images.githubusercontent.com/75872316/122635260-7a7ab780-d100-11eb-82a5-8ceeba3aff03.png">
</p>

**등차수열에 관련된 물제를 풀기 위한 일반적인 공식:**

<img src="https://render.githubusercontent.com/render/math?math=a">가 초항, <img src="https://render.githubusercontent.com/render/math?math=d">가 공차일 때:

- 산술평균 = `전체 항의 합 / 항의 개수`
- 등차급수 = `n * (초항 + 말항) / 2` = <img src="https://render.githubusercontent.com/render/math?math=\frac{n \cdot (2a %2b (n-1)d)}{2}">

## 영상 URL

- [Don't Memorise](https://youtu.be/gua96ju_FBk)
- [iBytes Academy (C++)](https://youtu.be/U_qtSRQYoPs)

## 출처

- [GeeksforGeeks](https://www.geeksforgeeks.org/arithmetic-progression)
